/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class EditCardDialog
extends CenteredJDialog {
    private static final String CREATENEW = "[...]";
    private Card cardToEdit;
    private JPanel mainPanel;
    private JPanel titlePanel;
    private JPanel editPanel;
    private JPanel buttonPanel;
    private WordListModel[] wordLists;
    private JList[] lists;
    private JScrollPane[] listScrollPanes;
    private JButton buttonCancel;
    private JButton buttonOkay;

    public EditCardDialog(Card card, Dialog dialog) {
        super(dialog, "Edit Card", 400, 300);
        this.cardToEdit = card;
        this.initLists();
        this.initFrame();
    }

    public EditCardDialog(Card card, Frame frame) {
        super(frame, "Edit Card", 400, 300);
        this.cardToEdit = card;
        this.initLists();
        this.initFrame();
    }

    private void initLists() {
        this.wordLists = new WordListModel[2];
        for (int i = 0; i <= 1; ++i) {
            String[] stringArray = this.cardToEdit.getSideAsArray(i);
            this.wordLists[i] = new WordListModel(stringArray, CREATENEW);
        }
    }

    private void initFrame() {
        this.setResizable(true);
        this.setModal(true);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(new GridLayout(1, 2));
        this.editPanel = new JPanel();
        this.editPanel.setLayout(new GridLayout(1, 2));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.titlePanel.add(new JLabel("Left side:"));
        this.titlePanel.add(new JLabel("Right side:"));
        this.lists = new JList[2];
        this.listScrollPanes = new JScrollPane[2];
        for (int i = 0; i <= 1; ++i) {
            this.lists[i] = new JList(this.wordLists[i]);
            this.lists[i].setSelectionMode(0);
            this.lists[i].addMouseListener(new MouseAtListListener(i));
            this.listScrollPanes[i] = new JScrollPane(this.lists[i]);
            this.listScrollPanes[i].setHorizontalScrollBarPolicy(31);
            this.listScrollPanes[i].setVerticalScrollBarPolicy(20);
            this.editPanel.add(this.listScrollPanes[i]);
        }
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(new CancelButtonListener());
        this.buttonOkay = new JButton("OK");
        this.buttonOkay.addActionListener(new OkayButtonListener());
        this.buttonPanel.add(this.buttonCancel);
        this.buttonPanel.add(this.buttonOkay);
        this.mainPanel.add((Component)this.titlePanel, "North");
        this.mainPanel.add((Component)this.editPanel, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    class OkayButtonListener
    implements ActionListener {
        OkayButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EditCardDialog.this.wordLists[0].getSize() == 1 && EditCardDialog.this.wordLists[1].getSize() == 1) {
                JOptionPane.showMessageDialog(EditCardDialog.this, "Card is empty.", "Error", 0);
                return;
            }
            EditCardDialog.this.cardToEdit.removeAllWords();
            for (int i = 0; i <= 1; ++i) {
                for (int j = 0; j < EditCardDialog.this.wordLists[i].getSize() - 1; ++j) {
                    EditCardDialog.this.cardToEdit.addWord((String)EditCardDialog.this.wordLists[i].getElementAt(j), i);
                }
            }
            EditCardDialog.this.dispose();
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditCardDialog.this.dispose();
        }
    }

    class MouseAtListListener
    extends MouseAdapter {
        private int side;

        public MouseAtListListener(int n) {
            this.side = n;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EditCardDialog.this.lists[this.side].locationToIndex(mouseEvent.getPoint());
                String string = (String)EditCardDialog.this.wordLists[this.side].getElementAt(n);
                if (n == EditCardDialog.this.wordLists[this.side].getSize() - 1) {
                    String string2 = JOptionPane.showInputDialog(EditCardDialog.this, "", "");
                    if (string2 != null) {
                        string2.trim();
                        if (!string2.equals("")) {
                            EditCardDialog.this.lists[this.side].setValueIsAdjusting(true);
                            EditCardDialog.this.wordLists[this.side].addWord(string2);
                            EditCardDialog.this.lists[this.side].setValueIsAdjusting(false);
                        }
                    }
                } else {
                    String string3 = JOptionPane.showInputDialog(EditCardDialog.this, "", string);
                    if (string3 != null) {
                        string3.trim();
                        EditCardDialog.this.lists[this.side].setValueIsAdjusting(true);
                        if (string3.equals("")) {
                            EditCardDialog.this.wordLists[this.side].removeWord(n);
                        } else {
                            EditCardDialog.this.wordLists[this.side].updateWord(n, string3);
                        }
                        EditCardDialog.this.lists[this.side].setValueIsAdjusting(false);
                    }
                }
            }
        }
    }
}

