/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class EditBoxsetDialog
extends CenteredJDialog {
    private JPanel mainPanel;
    private JPanel buttonPanelLeft;
    private JPanel buttonPanelRight;
    private JPanel buttonPanel;
    private CardTableModel cardTable;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JButton butAdd;
    private JButton butDelete;
    private JButton butEdit;
    private JButton butClose;

    public EditBoxsetDialog(Boxset boxset, Dialog dialog) {
        super(dialog, "Edit Boxset", 600, 300);
        this.cardTable = new CardTableModel(boxset);
        this.initFrame();
    }

    public EditBoxsetDialog(Boxset boxset, Frame frame) {
        super(frame, "Edit Boxset", 600, 300);
        this.cardTable = new CardTableModel(boxset);
        this.initFrame();
    }

    private void initFrame() {
        this.setResizable(true);
        this.setModal(true);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.buttonPanelLeft = new JPanel();
        this.buttonPanelLeft.setLayout(new FlowLayout(0));
        this.buttonPanelRight = new JPanel();
        this.buttonPanelRight.setLayout(new FlowLayout(2));
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2));
        this.table = new JTable(this.cardTable);
        this.table.setCellSelectionEnabled(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(true);
        this.table.addMouseListener(new MouseAtTableListener());
        for (int i = 0; i < 3; ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(50);
                continue;
            }
            tableColumn.setPreferredWidth(300);
        }
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.setHorizontalScrollBarPolicy(31);
        this.tableScrollPane.setVerticalScrollBarPolicy(20);
        this.butAdd = new JButton("New Card");
        this.butAdd.addActionListener(new AddButtonListener());
        this.buttonPanelLeft.add(this.butAdd);
        this.butDelete = new JButton("Delete");
        this.butDelete.addActionListener(new DeleteButtonListener());
        this.buttonPanelLeft.add(this.butDelete);
        this.butEdit = new JButton("Edit");
        this.butEdit.addActionListener(new EditButtonListener());
        this.buttonPanelLeft.add(this.butEdit);
        this.butClose = new JButton("Close");
        this.butClose.addActionListener(new CloseButtonListener());
        this.buttonPanelRight.add(this.butClose);
        this.buttonPanel.add(this.buttonPanelLeft);
        this.buttonPanel.add(this.buttonPanelRight);
        this.mainPanel.add((Component)this.tableScrollPane, "Center");
        this.mainPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    class MouseAtTableListener
    extends MouseAdapter {
        MouseAtTableListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EditBoxsetDialog.this.table.rowAtPoint(mouseEvent.getPoint());
                Card card = EditBoxsetDialog.this.cardTable.getCardOfRow(n);
                new EditCardDialog(card, EditBoxsetDialog.this).show();
                EditBoxsetDialog.this.cardTable.fireTableRowsUpdated(n, n);
            }
        }
    }

    class CloseButtonListener
    implements ActionListener {
        CloseButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditBoxsetDialog.this.dispose();
        }
    }

    class EditButtonListener
    implements ActionListener {
        EditButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditBoxsetDialog.this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            Card card = EditBoxsetDialog.this.cardTable.getCardOfRow(n);
            new EditCardDialog(card, EditBoxsetDialog.this).show();
            EditBoxsetDialog.this.cardTable.fireTableRowsUpdated(n, n);
        }
    }

    class DeleteButtonListener
    implements ActionListener {
        DeleteButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EditBoxsetDialog.this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            if (!this.areYouSure("Delete selected card?")) {
                return;
            }
            int n2 = Integer.parseInt((String)EditBoxsetDialog.this.table.getValueAt(n, 0)) - 1;
            EditBoxsetDialog.this.cardTable.deleteCard(n, n2);
        }

        private boolean areYouSure(String string) {
            int n = JOptionPane.showConfirmDialog(EditBoxsetDialog.this, string, "Warning", 2, 2);
            return n == 0;
        }
    }

    class AddButtonListener
    implements ActionListener {
        AddButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Card card = new Card();
            new EditCardDialog(card, EditBoxsetDialog.this).show();
            if (card.getNumWords(0) > 0 || card.getNumWords(1) > 0) {
                EditBoxsetDialog.this.cardTable.addNewCard(card, 0);
            }
        }
    }
}

