/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class CardsNBoxes
extends JFrame {
    public static final String VERSION = "Cards'n'Boxes 0.17";
    public static final String VERSION_DATE = "2008-03-15";
    private static final String fileEncoding = "utf-8";
    private static final String lookAndFeelTheme = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final short STATUS_IDLE = 0;
    public static final short STATUS_CARDNEW = 1;
    public static final short STATUS_CARDCHECKED = 2;
    private JPanel mainPanel;
    private JPanel boxInfoPanel;
    private JTextPane dialogText;
    private JTextField inputText;
    private JFileChooser fChooser;
    private ImageIcon[] iconIdle;
    private ImageIcon[] iconFinished;
    private ImageIcon[] iconActive;
    private ImageIcon iconNothing;
    private JMenuBar menubar;
    private JMenu menuFile;
    private JMenuItem menuNew;
    private JMenuItem menuOpen;
    private JMenuItem menuSave;
    private JMenuItem menuSaveAs;
    private JMenuItem menuQuit;
    private JMenu menuEdit;
    private JMenuItem menuEditCard;
    private JMenuItem menuEditBoxset;
    private JMenu menuBoxset;
    private JMenuItem menuSetNumBoxes;
    private JMenuItem menuReset;
    private JMenu menuGotoBox;
    private JMenuItem[] menuGotoBoxItems;
    private JMenu menuOptions;
    private JMenu menuSideToAskFor;
    private JRadioButtonMenuItem menuLeftSide;
    private JRadioButtonMenuItem menuRightSide;
    private JMenu menuToDoIfWrong;
    private JRadioButtonMenuItem menuAllDownIfWrong;
    private JRadioButtonMenuItem menuOneDownIfWrong;
    private JMenu menuNextBoxAlgo;
    private JRadioButtonMenuItem menuUseWaitCount;
    private JRadioButtonMenuItem menuAlwaysLowest;
    private JMenu menuMenuHelp;
    private JMenuItem menuHelp;
    private JMenuItem menuAbout;
    private short status;
    private BoxsetWorker bsWorker;
    private int sideToAskFor;
    private int toDoIfWrong;
    private int nextBoxAlgo;
    private File actualFile;
    private boolean justSaved;

    public CardsNBoxes() {
        super(VERSION);
        try {
            UIManager.setLookAndFeel(lookAndFeelTheme);
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.iconIdle = new ImageIcon[9];
        this.iconFinished = new ImageIcon[9];
        this.iconActive = new ImageIcon[9];
        this.iconNothing = new ImageIcon(this.getClass().getResource("icons/nothing.png"));
        this.iconIdle[0] = new ImageIcon(this.getClass().getResource("icons/gray_0cards.png"));
        this.iconIdle[1] = new ImageIcon(this.getClass().getResource("icons/gray_1cards.png"));
        this.iconIdle[2] = new ImageIcon(this.getClass().getResource("icons/gray_2cards.png"));
        this.iconIdle[3] = new ImageIcon(this.getClass().getResource("icons/gray_3cards.png"));
        this.iconIdle[4] = new ImageIcon(this.getClass().getResource("icons/gray_4cards.png"));
        this.iconIdle[5] = new ImageIcon(this.getClass().getResource("icons/gray_5cards.png"));
        this.iconIdle[6] = new ImageIcon(this.getClass().getResource("icons/gray_6cards.png"));
        this.iconIdle[7] = new ImageIcon(this.getClass().getResource("icons/gray_7cards.png"));
        this.iconIdle[8] = new ImageIcon(this.getClass().getResource("icons/gray_8cards.png"));
        this.iconFinished[0] = new ImageIcon(this.getClass().getResource("icons/yellow_0cards.png"));
        this.iconFinished[1] = new ImageIcon(this.getClass().getResource("icons/yellow_1cards.png"));
        this.iconFinished[2] = new ImageIcon(this.getClass().getResource("icons/yellow_2cards.png"));
        this.iconFinished[3] = new ImageIcon(this.getClass().getResource("icons/yellow_3cards.png"));
        this.iconFinished[4] = new ImageIcon(this.getClass().getResource("icons/yellow_4cards.png"));
        this.iconFinished[5] = new ImageIcon(this.getClass().getResource("icons/yellow_5cards.png"));
        this.iconFinished[6] = new ImageIcon(this.getClass().getResource("icons/yellow_6cards.png"));
        this.iconFinished[7] = new ImageIcon(this.getClass().getResource("icons/yellow_7cards.png"));
        this.iconFinished[8] = new ImageIcon(this.getClass().getResource("icons/yellow_8cards.png"));
        this.iconActive[0] = new ImageIcon(this.getClass().getResource("icons/red_0cards.png"));
        this.iconActive[1] = new ImageIcon(this.getClass().getResource("icons/red_1cards.png"));
        this.iconActive[2] = new ImageIcon(this.getClass().getResource("icons/red_2cards.png"));
        this.iconActive[3] = new ImageIcon(this.getClass().getResource("icons/red_3cards.png"));
        this.iconActive[4] = new ImageIcon(this.getClass().getResource("icons/red_4cards.png"));
        this.iconActive[5] = new ImageIcon(this.getClass().getResource("icons/red_5cards.png"));
        this.iconActive[6] = new ImageIcon(this.getClass().getResource("icons/red_6cards.png"));
        this.iconActive[7] = new ImageIcon(this.getClass().getResource("icons/red_7cards.png"));
        this.iconActive[8] = new ImageIcon(this.getClass().getResource("icons/red_8cards.png"));
        this.sideToAskFor = 0;
        this.toDoIfWrong = 0;
        this.nextBoxAlgo = 1;
        this.status = 0;
        this.actualFile = null;
        this.justSaved = true;
        this.setLocation(150, 100);
        this.setSize(400, 300);
        this.fChooser = new JFileChooser();
        this.fChooser.addChoosableFileFilter(new CNBFileFilter());
        this.initMenu();
        this.initFrame();
    }

    private void initFrame() {
        this.mainPanel = new JPanel();
        this.dialogText = new JTextPane();
        this.inputText = new JTextField();
        this.dialogText.setEditable(false);
        this.dialogText.setBackground(Color.white);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        StyledDocument styledDocument = this.dialogText.getStyledDocument();
        styledDocument.setParagraphAttributes(0, 0, simpleAttributeSet, true);
        this.inputText.setEnabled(false);
        this.inputText.addActionListener(new InputEvent());
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.dialogText, "Center");
        this.mainPanel.add((Component)this.inputText, "South");
        this.updateBoxInfoPanel();
        this.getContentPane().add(this.mainPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new FrameListener());
    }

    private void initMenu() {
        this.menubar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuNew = new JMenuItem("New");
        this.menuNew.addActionListener(new MenuListener(11));
        this.menuFile.add(this.menuNew);
        this.menuOpen = new JMenuItem("Open...");
        this.menuOpen.addActionListener(new MenuListener(12));
        this.menuFile.add(this.menuOpen);
        this.menuSave = new JMenuItem("Save");
        this.menuSave.addActionListener(new MenuListener(13));
        this.menuFile.add(this.menuSave);
        this.menuSaveAs = new JMenuItem("Save As...");
        this.menuSaveAs.addActionListener(new MenuListener(14));
        this.menuFile.add(this.menuSaveAs);
        this.menuFile.addSeparator();
        this.menuQuit = new JMenuItem("Quit");
        this.menuQuit.addActionListener(new MenuListener(19));
        this.menuFile.add(this.menuQuit);
        this.menubar.add(this.menuFile);
        this.menuEdit = new JMenu("Edit");
        this.menuEditBoxset = new JMenuItem("Edit Boxset");
        this.menuEditBoxset.addActionListener(new MenuListener(21));
        this.menuEdit.add(this.menuEditBoxset);
        this.menuEditCard = new JMenuItem("Edit Card");
        this.menuEditCard.addActionListener(new MenuListener(22));
        this.menuEdit.add(this.menuEditCard);
        this.menubar.add(this.menuEdit);
        this.menuBoxset = new JMenu("Boxset");
        this.menuSetNumBoxes = new JMenuItem("Set Number of Boxes");
        this.menuSetNumBoxes.addActionListener(new MenuListener(31));
        this.menuBoxset.add(this.menuSetNumBoxes);
        this.menuReset = new JMenuItem("Reset Boxset");
        this.menuReset.addActionListener(new MenuListener(32));
        this.menuBoxset.add(this.menuReset);
        this.menuGotoBox = new JMenu("Go to ...");
        this.menuGotoBox.addMouseListener(new GotoBoxMenuListener());
        this.menuBoxset.add(this.menuGotoBox);
        this.menubar.add(this.menuBoxset);
        this.menuOptions = new JMenu("Options");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.menuSideToAskFor = new JMenu("Hidden Side");
        this.menuLeftSide = new JRadioButtonMenuItem("Left Side", true);
        this.menuLeftSide.addActionListener(new MenuListener(811));
        buttonGroup.add(this.menuLeftSide);
        this.menuSideToAskFor.add(this.menuLeftSide);
        this.menuRightSide = new JRadioButtonMenuItem("Right Side");
        this.menuRightSide.addActionListener(new MenuListener(812));
        buttonGroup.add(this.menuRightSide);
        this.menuSideToAskFor.add(this.menuRightSide);
        this.menuOptions.add(this.menuSideToAskFor);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.menuToDoIfWrong = new JMenu("Wrong Answered Card");
        this.menuAllDownIfWrong = new JRadioButtonMenuItem("To Lowest Box", true);
        this.menuAllDownIfWrong.addActionListener(new MenuListener(821));
        buttonGroup2.add(this.menuAllDownIfWrong);
        this.menuToDoIfWrong.add(this.menuAllDownIfWrong);
        this.menuOneDownIfWrong = new JRadioButtonMenuItem("One Box Down");
        this.menuOneDownIfWrong.addActionListener(new MenuListener(822));
        buttonGroup2.add(this.menuOneDownIfWrong);
        this.menuToDoIfWrong.add(this.menuOneDownIfWrong);
        this.menuOptions.add(this.menuToDoIfWrong);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.menuNextBoxAlgo = new JMenu("Next Box Selection");
        this.menuUseWaitCount = new JRadioButtonMenuItem("By Wait Count", true);
        this.menuUseWaitCount.addActionListener(new MenuListener(831));
        buttonGroup3.add(this.menuUseWaitCount);
        this.menuNextBoxAlgo.add(this.menuUseWaitCount);
        this.menuAlwaysLowest = new JRadioButtonMenuItem("Always Lowest");
        this.menuAlwaysLowest.addActionListener(new MenuListener(832));
        buttonGroup3.add(this.menuAlwaysLowest);
        this.menuNextBoxAlgo.add(this.menuAlwaysLowest);
        this.menuOptions.add(this.menuNextBoxAlgo);
        this.menubar.add(this.menuOptions);
        this.menuMenuHelp = new JMenu("Help");
        this.menuHelp = new JMenuItem("Help");
        this.menuHelp.addActionListener(new MenuListener(91));
        this.menuMenuHelp.add(this.menuHelp);
        this.menuAbout = new JMenuItem("About");
        this.menuAbout.addActionListener(new MenuListener(99));
        this.menuMenuHelp.add(this.menuAbout);
        this.menubar.add(this.menuMenuHelp);
        this.menuGotoBoxItems = new JMenuItem[9];
        for (int i = 0; i < this.menuGotoBoxItems.length; ++i) {
            this.menuGotoBoxItems[i] = new JMenuItem("Box " + (i + 1));
            this.menuGotoBoxItems[i].addActionListener(new GotoBoxItemListener(i));
        }
        this.setJMenuBar(this.menubar);
        this.enableMenu();
    }

    private boolean areYouSure(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, "Warning", 2, 2);
        return n == 0;
    }

    private boolean askForSaving() {
        if (this.bsWorker != null && !this.justSaved) {
            int n = JOptionPane.showConfirmDialog(this, "Save boxset?", "Warning", 1, 2);
            switch (n) {
                case 0: {
                    this.save();
                    return true;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private void updateBoxInfoPanel() {
        if (this.boxInfoPanel != null) {
            this.boxInfoPanel.removeAll();
            this.mainPanel.remove(this.boxInfoPanel);
        }
        this.boxInfoPanel = new JPanel();
        this.boxInfoPanel.setBackground(Color.white);
        if (this.bsWorker != null) {
            int n = this.bsWorker.getNumBoxes();
            int n2 = this.bsWorker.getActualBoxIndex();
            this.boxInfoPanel.setLayout(new GridLayout(1, n));
            for (int i = n - 1; i >= 0; --i) {
                int n3 = this.bsWorker.getNumCards();
                int n4 = this.bsWorker.getCardbox(i).getNumCards();
                double d = (double)n4 / (double)n3;
                int n5 = d > 0.875 ? 8 : (d > 0.75 ? 7 : (d > 0.625 ? 6 : (d > 0.5 ? 5 : (d > 0.375 ? 4 : (d > 0.25 ? 3 : (d > 0.125 ? 2 : (n4 > 0 ? 1 : 0)))))));
                JLabel jLabel = i == n - 1 ? new JLabel("" + n4, this.iconFinished[n5], 0) : (i == n2 ? new JLabel("" + n4, this.iconActive[n5], 0) : new JLabel("" + n4, this.iconIdle[n5], 0));
                jLabel.setVerticalTextPosition(3);
                jLabel.setHorizontalTextPosition(0);
                if (i != n - 1) {
                    jLabel.addMouseListener(new GotoBoxItemListener(i));
                }
                this.boxInfoPanel.add(jLabel);
            }
            this.mainPanel.add((Component)this.boxInfoPanel, "North");
        } else {
            this.boxInfoPanel.setLayout(new GridLayout(1, 1));
            JLabel jLabel = new JLabel(" ", this.iconNothing, 0);
            jLabel.setVerticalTextPosition(3);
            jLabel.setHorizontalTextPosition(0);
            this.boxInfoPanel.add(jLabel);
            this.mainPanel.add((Component)this.boxInfoPanel, "North");
        }
        this.boxInfoPanel.repaint();
    }

    private boolean setNumBoxes() {
        block7: {
            int n;
            block6: {
                n = 0;
                while (n < 2 || n > 9) {
                    String string = "How many cardboxes shall be used (2-9)?\n";
                    String string2 = JOptionPane.showInputDialog(this, string, Integer.toString(this.bsWorker.getNumBoxes()));
                    if (string2 == null) {
                        return false;
                    }
                    try {
                        n = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = -1;
                    }
                    if (n >= 2 && n <= 9) continue;
                    string = "Number of boxes must be between 2 and 9!";
                    JOptionPane.showMessageDialog(this, string, "Error", 0);
                }
                if (n <= this.bsWorker.getNumBoxes()) break block6;
                for (int i = this.bsWorker.getNumBoxes(); i < n; ++i) {
                    this.bsWorker.addCardbox();
                }
                break block7;
            }
            if (n >= this.bsWorker.getNumBoxes()) break block7;
            for (int i = this.bsWorker.getNumBoxes(); i > n; --i) {
                this.bsWorker.removeCardbox();
            }
        }
        return true;
    }

    private boolean createAllNewBoxset() {
        boolean bl = true;
        this.bsWorker = new BoxsetWorker(this.toDoIfWrong, this.nextBoxAlgo);
        this.actualFile = null;
        boolean bl2 = this.setNumBoxes();
        if (!bl2) {
            this.bsWorker = null;
            bl = false;
        }
        this.enableMenu();
        this.stopTest();
        return bl;
    }

    private void loadVocFile(File file) {
        Object object;
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), fileEncoding));
            this.bsWorker = new BoxsetWorker((BufferedReader)object, this.toDoIfWrong, this.nextBoxAlgo);
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(9);
        }
        if (!this.bsWorker.numBoxesSpecInFile()) {
            this.setNumBoxes();
        }
        object = "Loaded Cards: " + this.bsWorker.getNumCards() + "\nCreated Cardboxes: " + this.bsWorker.getNumBoxes();
        JOptionPane.showMessageDialog(this, object, "Info", 1);
        this.enableMenu();
        this.startTest();
    }

    private void enableMenu() {
        if (this.bsWorker != null) {
            this.menuSave.setEnabled(true);
            this.menuSaveAs.setEnabled(true);
            this.menuEditBoxset.setEnabled(true);
            this.menuSetNumBoxes.setEnabled(true);
            this.menuReset.setEnabled(true);
        } else {
            this.menuSave.setEnabled(false);
            this.menuSaveAs.setEnabled(false);
            this.menuEditBoxset.setEnabled(false);
            this.menuEditCard.setEnabled(false);
            this.menuSetNumBoxes.setEnabled(false);
            this.menuReset.setEnabled(false);
            this.menuGotoBox.setEnabled(false);
        }
    }

    private int saveVocFile(File file) {
        if (file == null) {
            return -1;
        }
        int n = 0;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), fileEncoding));
            n = this.bsWorker.saveBoxsetToFile(bufferedWriter);
            bufferedWriter.close();
            String string = "Boxset saved to '" + file.getName() + "'\n(" + n + " lines written.)";
            JOptionPane.showMessageDialog(this, string, "Info", 1);
            this.justSaved = true;
        }
        catch (Exception exception) {
            String string = "An error occured during saving.\n(" + n + " lines written.)";
            JOptionPane.showMessageDialog(this, string, "Error", 0);
        }
        return n;
    }

    private void startTest() {
        if (this.bsWorker.getNumCards() <= 0) {
            this.stopTest();
            return;
        }
        this.status = 1;
        this.updateBoxInfoPanel();
        this.inputText.setEnabled(true);
        this.inputText.requestFocus();
        this.menuEditCard.setEnabled(true);
        this.menuGotoBox.setEnabled(true);
        if (this.displayCard(true) == null) {
            this.stopTest();
            JOptionPane.showMessageDialog(this, "Boxset is finished.", "Info", 1);
        }
    }

    private void stopTest() {
        this.inputText.setEnabled(false);
        this.menuEditCard.setEnabled(false);
        this.menuGotoBox.setEnabled(false);
        this.inputText.setText("");
        this.dialogText.setText("");
        this.updateBoxInfoPanel();
        this.status = 0;
    }

    private Card displayCard(boolean bl) {
        Card card = bl ? this.bsWorker.getNextCard() : this.bsWorker.getActualCard();
        if (card != null) {
            this.updateBoxInfoPanel();
            this.inputText.setText("");
            this.dialogText.setText("\n\n\n" + card.getSide(1 - this.sideToAskFor));
            this.status = 1;
        }
        return card;
    }

    private void checkInput() {
        Card card = this.bsWorker.getActualCard();
        String string = this.inputText.getText();
        this.inputText.setText("");
        boolean bl = card.isWordOnCard(string, this.sideToAskFor);
        if (bl) {
            this.dialogText.setText("\n\n\n" + card.getSide(0) + " - " + card.getSide(1) + "\n\nCorrect!");
        } else {
            this.dialogText.setText("\n\n\n" + card.getSide(0) + " - " + card.getSide(1) + "\n\nWRONG!");
        }
        this.bsWorker.moveActualCard(bl);
    }

    private void save() {
        if (this.bsWorker != null) {
            if (this.actualFile != null) {
                this.saveVocFile(this.actualFile);
            } else {
                this.saveAs();
            }
        }
    }

    private void saveAs() {
        int n;
        boolean bl = false;
        File file = null;
        if (this.actualFile != null) {
            this.fChooser.setSelectedFile(this.actualFile);
        }
        if ((n = this.fChooser.showSaveDialog(this)) == 0 && (file = this.fChooser.getSelectedFile()) != null) {
            String string;
            String string2 = CNBFileFilter.getFilterExtension();
            if (!string2.equals(string = CNBFileFilter.getExtension(file))) {
                String string3 = file.getAbsolutePath();
                file = new File(string3 + "." + string2);
            }
            bl = true;
            while (file.exists() && !this.areYouSure("File already exists. Overwrite?")) {
                n = this.fChooser.showSaveDialog(this);
                if (n == 0) {
                    file = this.fChooser.getSelectedFile();
                    continue;
                }
                bl = false;
                break;
            }
        }
        if (bl) {
            this.actualFile = file;
            this.saveVocFile(this.actualFile);
        }
    }

    private void quit() {
        if (this.askForSaving()) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        File file;
        CardsNBoxes cardsNBoxes = new CardsNBoxes();
        cardsNBoxes.show();
        if (stringArray.length > 0 && (file = new File(stringArray[0])).canRead()) {
            cardsNBoxes.actualFile = file;
            cardsNBoxes.loadVocFile(file);
        }
    }

    class FrameListener
    extends WindowAdapter {
        FrameListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            CardsNBoxes.this.quit();
        }
    }

    class InputEvent
    implements ActionListener {
        InputEvent() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (CardsNBoxes.this.status) {
                case 2: {
                    if (CardsNBoxes.this.displayCard(true) != null) break;
                    CardsNBoxes.this.stopTest();
                    JOptionPane.showMessageDialog(CardsNBoxes.this, "Boxset is finished.", "Info", 1);
                    break;
                }
                case 1: {
                    CardsNBoxes.this.checkInput();
                    CardsNBoxes.this.status = (short)2;
                }
            }
            CardsNBoxes.this.justSaved = false;
        }
    }

    class GotoBoxItemListener
    implements ActionListener,
    MouseListener {
        private int targetIndex;

        public GotoBoxItemListener(int n) {
            this.targetIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.activateBox();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.activateBox();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private void activateBox() {
            if (CardsNBoxes.this.status != 0 && CardsNBoxes.this.bsWorker != null && CardsNBoxes.this.bsWorker.forceBox(this.targetIndex)) {
                CardsNBoxes.this.displayCard(true);
            }
        }
    }

    class GotoBoxMenuListener
    extends MouseAdapter {
        GotoBoxMenuListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (CardsNBoxes.this.menuGotoBox.isEnabled()) {
                boolean bl = false;
                CardsNBoxes.this.menuGotoBox.removeAll();
                for (int i = 0; i < 9; ++i) {
                    if (i >= CardsNBoxes.this.bsWorker.getNumBoxes() - 1 || i == CardsNBoxes.this.bsWorker.getActualBoxIndex() || CardsNBoxes.this.bsWorker.getCardbox(i).getNumCards() <= 0) continue;
                    CardsNBoxes.this.menuGotoBox.add(CardsNBoxes.this.menuGotoBoxItems[i]);
                    bl = true;
                }
                if (!bl) {
                    JMenuItem jMenuItem = new JMenuItem("  ---  ");
                    jMenuItem.setEnabled(false);
                    CardsNBoxes.this.menuGotoBox.add(jMenuItem);
                }
            }
        }
    }

    class MenuListener
    implements ActionListener {
        private int whatToDoIndex;
        public static final int NEW = 11;
        public static final int OPEN = 12;
        public static final int SAVE = 13;
        public static final int SAVE_AS = 14;
        public static final int QUIT = 19;
        public static final int EDIT_BOXSET = 21;
        public static final int EDIT_CARD = 22;
        public static final int SET_NUM_BOXES = 31;
        public static final int RESET = 32;
        public static final int SIDE_TO_ASK_FOR_LEFT = 811;
        public static final int SIDE_TO_ASK_FOR_RIGHT = 812;
        public static final int TO_DO_IF_WRONG_ALL_DOWN = 821;
        public static final int TO_DO_IF_WRONG_ONE_DOWN = 822;
        public static final int NEXT_BOX_ALGO_WAITCOUNT = 831;
        public static final int NEXT_BOX_ALGO_LOWESTBOX = 832;
        public static final int HELP = 91;
        public static final int ABOUT = 99;

        public MenuListener(int n) {
            this.whatToDoIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            switch (this.whatToDoIndex) {
                case 11: {
                    if (!CardsNBoxes.this.askForSaving() || !CardsNBoxes.this.createAllNewBoxset()) break;
                    new EditBoxsetDialog((Boxset)CardsNBoxes.this.bsWorker, CardsNBoxes.this).show();
                    CardsNBoxes.this.justSaved = false;
                    CardsNBoxes.this.startTest();
                    break;
                }
                case 12: {
                    int n;
                    if (!CardsNBoxes.this.askForSaving() || (n = CardsNBoxes.this.fChooser.showOpenDialog(CardsNBoxes.this)) != 0) break;
                    CardsNBoxes.this.actualFile = CardsNBoxes.this.fChooser.getSelectedFile();
                    CardsNBoxes.this.loadVocFile(CardsNBoxes.this.actualFile);
                    break;
                }
                case 13: {
                    CardsNBoxes.this.save();
                    break;
                }
                case 14: {
                    CardsNBoxes.this.saveAs();
                    break;
                }
                case 19: {
                    CardsNBoxes.this.quit();
                    break;
                }
                case 21: {
                    new EditBoxsetDialog((Boxset)CardsNBoxes.this.bsWorker, CardsNBoxes.this).show();
                    CardsNBoxes.this.justSaved = false;
                    CardsNBoxes.this.startTest();
                    break;
                }
                case 22: {
                    Card card = CardsNBoxes.this.bsWorker.getActualCard();
                    if (card == null) break;
                    new EditCardDialog(card, CardsNBoxes.this).show();
                    CardsNBoxes.this.justSaved = false;
                    CardsNBoxes.this.updateBoxInfoPanel();
                    CardsNBoxes.this.displayCard(false);
                    break;
                }
                case 31: {
                    boolean bl = CardsNBoxes.this.setNumBoxes();
                    if (!bl) break;
                    CardsNBoxes.this.updateBoxInfoPanel();
                    CardsNBoxes.this.startTest();
                    break;
                }
                case 32: {
                    if (CardsNBoxes.this.bsWorker == null || !CardsNBoxes.this.areYouSure("Reset Boxset?")) break;
                    CardsNBoxes.this.stopTest();
                    CardsNBoxes.this.bsWorker.reset();
                    CardsNBoxes.this.startTest();
                    break;
                }
                case 811: {
                    CardsNBoxes.this.sideToAskFor = 0;
                    if (CardsNBoxes.this.status != 1) break;
                    CardsNBoxes.this.displayCard(false);
                    break;
                }
                case 812: {
                    CardsNBoxes.this.sideToAskFor = 1;
                    if (CardsNBoxes.this.status != 1) break;
                    CardsNBoxes.this.displayCard(false);
                    break;
                }
                case 821: {
                    CardsNBoxes.this.toDoIfWrong = 0;
                    if (CardsNBoxes.this.bsWorker == null) break;
                    CardsNBoxes.this.bsWorker.setToDoIfWrong(0);
                    break;
                }
                case 822: {
                    CardsNBoxes.this.toDoIfWrong = 1;
                    if (CardsNBoxes.this.bsWorker == null) break;
                    CardsNBoxes.this.bsWorker.setToDoIfWrong(1);
                    break;
                }
                case 831: {
                    CardsNBoxes.this.nextBoxAlgo = 1;
                    if (CardsNBoxes.this.bsWorker == null) break;
                    CardsNBoxes.this.bsWorker.setNextBoxAlgo(1);
                    break;
                }
                case 832: {
                    CardsNBoxes.this.nextBoxAlgo = 0;
                    if (CardsNBoxes.this.bsWorker == null) break;
                    CardsNBoxes.this.bsWorker.setNextBoxAlgo(0);
                    break;
                }
                case 91: {
                    new HelpDialog(CardsNBoxes.this).show();
                    break;
                }
                case 99: {
                    new AboutDialog(CardsNBoxes.this).show();
                    break;
                }
            }
            CardsNBoxes.this.inputText.requestFocus();
        }
    }
}

