/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class CardTableModel
extends AbstractTableModel {
    private static final int NUMCOLS = 3;
    private Boxset bSet;
    private Vector boxnumbers;
    private Vector cards;

    public CardTableModel(Boxset boxset) {
        this.bSet = boxset;
        this.boxnumbers = new Vector();
        this.cards = new Vector();
        this.loadBoxset(boxset);
    }

    private void loadBoxset(Boxset boxset) {
        for (int i = 0; i < boxset.getNumBoxes(); ++i) {
            Cardbox cardbox = boxset.getCardbox(i);
            for (int j = 0; j < cardbox.getNumCards(); ++j) {
                this.boxnumbers.add(Integer.toString(i + 1));
                this.cards.add(cardbox.getCard(j));
            }
        }
    }

    private void reloadTable() {
        this.boxnumbers.removeAllElements();
        this.cards.removeAllElements();
        this.loadBoxset(this.bSet);
        this.fireTableRowsInserted(0, this.cards.size() - 1);
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Box";
            }
            case 1: {
                return "Left side";
            }
            case 2: {
                return "Right side";
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.cards.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return (String)this.boxnumbers.elementAt(n);
            }
            case 1: {
                Card card = (Card)this.cards.elementAt(n);
                return card.getSide(0);
            }
            case 2: {
                Card card = (Card)this.cards.elementAt(n);
                return card.getSide(1);
            }
        }
        return null;
    }

    public Card getCardOfRow(int n) {
        if (n < this.cards.size()) {
            return (Card)this.cards.elementAt(n);
        }
        return null;
    }

    public void addNewCard(Card card, int n) {
        Cardbox cardbox = this.bSet.getCardbox(n);
        if (cardbox != null) {
            cardbox.addCard(card);
            this.reloadTable();
        }
    }

    public void deleteCard(int n, int n2) {
        Card card = (Card)this.cards.elementAt(n);
        Cardbox cardbox = this.bSet.getCardbox(n2);
        if (card != null && cardbox != null) {
            cardbox.removeCard(card);
            this.reloadTable();
        }
    }
}

