/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Card {
    private int[] numWords = new int[2];
    private Vector[] sides = new Vector[2];

    public Card() {
        this.sides[0] = new Vector();
        this.sides[1] = new Vector();
        this.numWords[0] = 0;
        this.numWords[1] = 0;
    }

    public boolean addWord(String string, int n) {
        if (n != 0 && n != 1) {
            return false;
        }
        this.sides[n].add(string);
        int n2 = n;
        this.numWords[n2] = this.numWords[n2] + 1;
        return true;
    }

    public void removeAllWords() {
        this.sides[0].clear();
        this.sides[1].clear();
        this.numWords[0] = 0;
        this.numWords[1] = 0;
    }

    public int getNumWords(int n) {
        if (n != 0 && n != 1) {
            return -1;
        }
        return this.numWords[n];
    }

    public String getSide(int n) {
        return this.getSide(n, ", ");
    }

    public String getSide(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n != 0 && n != 1) {
            return null;
        }
        for (int i = 0; i < this.numWords[n]; ++i) {
            stringBuffer.append(this.sides[n].elementAt(i));
            if (i >= this.numWords[n] - 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String[] getSideAsArray(int n) {
        String[] stringArray = new String[this.numWords[n]];
        for (int i = 0; i < this.sides[n].size(); ++i) {
            stringArray[i] = (String)this.sides[n].elementAt(i);
        }
        return stringArray;
    }

    public boolean isWordOnCard(String string, int n) {
        boolean bl = false;
        if (n != 0 && n != 1) {
            return false;
        }
        String string2 = Card.stripSigns(string).trim();
        for (int i = 0; i < this.numWords[n]; ++i) {
            String string3 = Card.stripComments(Card.stripSigns((String)this.sides[n].elementAt(i)), "(", ")").trim();
            string3.trim();
            if (!string2.equalsIgnoreCase(string3)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static void rmACharFromString(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.indexOf(string);
        while (n != -1) {
            stringBuffer.deleteCharAt(n);
            n = stringBuffer.indexOf(string, n);
        }
    }

    public static String stripSigns(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Card.rmACharFromString(stringBuffer, ",");
        Card.rmACharFromString(stringBuffer, ".");
        Card.rmACharFromString(stringBuffer, "?");
        Card.rmACharFromString(stringBuffer, "!");
        return stringBuffer.toString();
    }

    public static String stripComments(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf(string2);
        int n2 = stringBuffer.indexOf(string3);
        while (n != -1 && n2 != -1) {
            stringBuffer.delete(n, n2 + 1);
            n = stringBuffer.indexOf(string2);
            n2 = stringBuffer.indexOf(string3);
        }
        Card.rmACharFromString(stringBuffer, "  ");
        return stringBuffer.toString();
    }
}

