/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;

public class BoxsetWorker
extends Boxset {
    public static final int ALLDOWNIFWRONG = 0;
    public static final int ONEDOWNIFWRONG = 1;
    public static final int LOWESTBOXMETHOD = 0;
    public static final int WAITCOUNTMETHOD = 1;
    private int toDoIfWrong;
    private int nextBoxAlgo;
    private int actualBoxIndex;
    private Cardbox actualBox;
    private Card actualCard;
    private int[] waitCount;

    public BoxsetWorker(BufferedReader bufferedReader, int n, int n2) throws IOException {
        super(bufferedReader);
        this.initBoxsetWorker(n, n2);
    }

    public BoxsetWorker(int n, int n2) {
        this.initBoxsetWorker(n, n2);
    }

    public BoxsetWorker(int n) {
        this(n, 1);
    }

    public BoxsetWorker() {
        this(0, 1);
    }

    private void initBoxsetWorker(int n, int n2) {
        this.toDoIfWrong = n != 0 && n != 1 ? 0 : n;
        this.nextBoxAlgo = n2 != 1 && n2 != 0 ? 1 : n2;
        this.actualBoxIndex = 0;
        this.actualBox = this.getCardbox(0);
        this.actualCard = null;
        this.resetWaitCount();
    }

    public void reset() {
        super.reset();
        this.resetWaitCount();
        this.actualBoxIndex = 0;
        this.actualBox = this.getCardbox(0);
        this.actualCard = null;
    }

    public boolean addCardbox(Cardbox cardbox) {
        boolean bl = super.addCardbox(cardbox);
        if (bl) {
            this.resetWaitCount();
            this.actualBoxIndex = 0;
            this.actualBox = this.getCardbox(0);
            this.actualCard = null;
        }
        return bl;
    }

    public boolean addCardbox() {
        return this.addCardbox(new Cardbox());
    }

    public boolean removeCardbox(int n) {
        boolean bl = super.removeCardbox(n);
        if (bl) {
            this.resetWaitCount();
            this.actualBoxIndex = 0;
            this.actualBox = this.getCardbox(0);
            this.actualCard = null;
        }
        return bl;
    }

    public boolean removeCardbox() {
        return this.removeCardbox(this.getNumBoxes() - 1);
    }

    public Card getNextCard() {
        if (this.getNumBoxes() < 1) {
            return null;
        }
        if (this.actualBox.getNumCards() == 0) {
            this.waitCount[this.actualBoxIndex] = 0;
            this.updateWaitCount();
            this.actualBoxIndex = this.nextBoxAlgo == 0 ? this.findLowestNotEmptyBox() : this.findHighestWaitCountBox();
            if (this.actualBoxIndex == this.getNumBoxes() - 1) {
                return null;
            }
            this.actualBox = this.getCardbox(this.actualBoxIndex);
        }
        this.actualCard = this.actualBox.getRandomCard();
        return this.actualCard;
    }

    public boolean moveActualCard(boolean bl) {
        boolean bl2 = false;
        if (this.actualCard != null) {
            if (bl) {
                Cardbox cardbox = this.getCardbox(this.actualBoxIndex + 1);
                this.actualBox.removeCard(this.actualCard);
                cardbox.addCard(this.actualCard);
            } else if (this.actualBoxIndex != 0) {
                this.actualBox.removeCard(this.actualCard);
                Cardbox cardbox = this.toDoIfWrong == 1 ? this.getCardbox(this.actualBoxIndex - 1) : this.getCardbox(0);
                cardbox.addCard(this.actualCard);
            }
            bl2 = true;
        }
        return bl2;
    }

    public boolean forceBox(int n) {
        boolean bl = false;
        if (n >= 0 && n < this.getNumBoxes() - 1 && n != this.actualBoxIndex && this.getCardbox(n).getNumCards() > 0) {
            this.waitCount[this.actualBoxIndex] = 0;
            this.updateWaitCount();
            this.actualBoxIndex = n;
            this.actualBox = this.getCardbox(n);
            this.actualCard = null;
            bl = true;
        }
        return bl;
    }

    public void setToDoIfWrong(int n) {
        if (n == 0 || n == 1) {
            this.toDoIfWrong = n;
        }
    }

    public void setNextBoxAlgo(int n) {
        if (n == 1 || n == 0) {
            this.nextBoxAlgo = n;
        }
    }

    public int getToDoIfWrong() {
        return this.toDoIfWrong;
    }

    public int getNextBoxAlgo() {
        return this.nextBoxAlgo;
    }

    public int getActualBoxIndex() {
        return this.actualBoxIndex;
    }

    public Card getActualCard() {
        return this.actualCard;
    }

    private int findLowestNotEmptyBox() {
        int n = -1;
        for (int i = 0; i < this.getNumBoxes(); ++i) {
            if (this.getCardbox(i).getNumCards() <= 0) continue;
            n = i;
            break;
        }
        if (n >= this.getNumBoxes() - 1) {
            n = this.getNumBoxes() - 1;
        }
        return n;
    }

    private int findHighestWaitCountBox() {
        int n = 0;
        for (int i = 0; i < this.getNumBoxes() - 1; ++i) {
            if (this.waitCount[i] <= this.waitCount[n]) continue;
            n = i;
        }
        if (this.getCardbox(n).getNumCards() == 0) {
            n = this.getNumBoxes() - 1;
        }
        return n;
    }

    private void updateWaitCount() {
        for (int i = 0; i < this.getNumBoxes() - 1; ++i) {
            this.waitCount[i] = this.getCardbox(i).getNumCards() > 0 ? this.waitCount[i] + 1 : 0;
        }
    }

    private void resetWaitCount() {
        this.waitCount = new int[this.getNumBoxes()];
        for (int i = 0; i < this.getNumBoxes(); ++i) {
            this.waitCount[i] = 0;
        }
        this.updateWaitCount();
    }
}

