/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Vector;

class Boxset {
    public static final int MIN_NUMBOXES = 2;
    public static final int MAX_NUMBOXES = 9;
    private Vector boxes = new Vector();
    private int numBoxes = 0;
    private boolean numBoxesSpecInFile = false;

    public Boxset() {
        for (int i = 0; i < 2; ++i) {
            this.addCardbox();
        }
    }

    public Boxset(BufferedReader bufferedReader) throws IOException {
        this();
        String string;
        int n = this.numBoxes - 1;
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            Card card;
            int n2;
            int n3;
            if (bl) {
                bl = false;
                int n4 = this.processFirstLine(string);
                int n5 = n4 - 1;
                if (n5 > -1) {
                    for (n3 = n + 1; n3 <= n5; ++n3) {
                        this.addCardbox();
                        ++n;
                    }
                    this.numBoxesSpecInFile = true;
                    continue;
                }
            }
            if ((n2 = this.processLineToCard(card = new Card(), string)) == -1) {
                card = null;
                continue;
            }
            if (n2 > n) {
                for (n3 = n + 1; n3 <= n2; ++n3) {
                    Cardbox cardbox = new Cardbox();
                    this.addCardbox(cardbox);
                    ++n;
                }
            }
            ((Cardbox)this.boxes.elementAt(n2)).addCard(card);
        }
    }

    public void reset() {
        Cardbox cardbox = this.getCardbox(0);
        for (int i = 1; i < this.numBoxes; ++i) {
            Cardbox cardbox2 = this.getCardbox(i);
            Card card = cardbox2.getCard(0);
            while (card != null) {
                cardbox2.removeCard(card);
                cardbox.addCard(card);
                card = cardbox2.getCard(0);
            }
        }
    }

    public boolean addCardbox(Cardbox cardbox) {
        boolean bl = false;
        if (this.numBoxes < 9) {
            this.boxes.add(cardbox);
            ++this.numBoxes;
            bl = true;
        }
        return bl;
    }

    public boolean addCardbox() {
        return this.addCardbox(new Cardbox());
    }

    public boolean removeCardbox(int n) {
        boolean bl = false;
        if (this.numBoxes > 2 && n > 0 && n < this.numBoxes) {
            Cardbox cardbox = this.getCardbox(n);
            Cardbox cardbox2 = this.getCardbox(n - 1);
            while (cardbox.getNumCards() > 0) {
                Card card = cardbox.getCard(0);
                cardbox.removeCard(card);
                cardbox2.addCard(card);
            }
            this.boxes.remove(cardbox);
            --this.numBoxes;
            bl = true;
        }
        return bl;
    }

    public boolean removeCardbox() {
        return this.removeCardbox(this.numBoxes - 1);
    }

    public int getNumBoxes() {
        return this.numBoxes;
    }

    public int getNumCards() {
        int n = 0;
        for (int i = 0; i < this.numBoxes; ++i) {
            n += ((Cardbox)this.boxes.elementAt(i)).getNumCards();
        }
        return n;
    }

    public Cardbox getCardbox(int n) {
        if (n >= this.numBoxes) {
            return null;
        }
        return (Cardbox)this.boxes.elementAt(n);
    }

    public boolean numBoxesSpecInFile() {
        return this.numBoxesSpecInFile;
    }

    public int saveBoxsetToFile(BufferedWriter bufferedWriter) throws IOException {
        int n = 0;
        bufferedWriter.write("##" + this.numBoxes + "##\n");
        ++n;
        for (int i = 0; i < this.numBoxes; ++i) {
            for (int j = 0; j < ((Cardbox)this.boxes.elementAt(i)).getNumCards(); ++j) {
                Card card = ((Cardbox)this.boxes.elementAt(i)).getCard(j);
                bufferedWriter.write("#" + (i + 1) + "# ");
                bufferedWriter.write(card.getSide(0, " | "));
                bufferedWriter.write(" :: ");
                bufferedWriter.write(card.getSide(1, " | "));
                bufferedWriter.write("\n");
                ++n;
            }
        }
        bufferedWriter.flush();
        return n;
    }

    private int processFirstLine(String string) {
        char[] cArray;
        int n = -1;
        if (string.length() >= 5 && string.charAt(0) == '#' && string.charAt(1) == '#' && string.charAt(3) == '#' && string.charAt(4) == '#' && Character.isDigit((cArray = new char[]{string.charAt(2)})[0])) {
            n = Integer.parseInt(new String(cArray));
        }
        return n;
    }

    private int processLineToCard(Card card, String string) {
        int n;
        Object[] objectArray;
        int n2 = -1;
        String string2 = null;
        String string3 = null;
        String[] stringArray = string.split("::");
        if (stringArray.length != 2) {
            return n2;
        }
        string3 = stringArray[1];
        String[] stringArray2 = stringArray[0].split("#");
        if (stringArray2.length == 3) {
            if (Character.isDigit(stringArray2[1].charAt(0))) {
                objectArray = new char[]{stringArray2[1].charAt(0)};
                n2 = Integer.parseInt(new String((char[])objectArray));
                --n2;
                string2 = stringArray2[2];
            }
        } else if (stringArray2.length == 1) {
            string2 = stringArray2[0];
        } else {
            return n2;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        objectArray = string2.split("\\|");
        for (n = 0; n < objectArray.length; ++n) {
            card.addWord(objectArray[n].trim(), 0);
        }
        String[] stringArray3 = string3.split("\\|");
        for (n = 0; n < stringArray3.length; ++n) {
            card.addWord(stringArray3[n].trim(), 1);
        }
        return n2;
    }
}

